<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

echo '<h1 class="page-header">Mu Roulette Unused Tickets</h1>';

$MuRoulette = new \Plugin\MuRoulette\MuRoulette();
$logs = $MuRoulette->getFullUnusedTicketsList();

echo '<div class="row">';
	echo '<div class="col-md-12">';
		if(is_array($logs)) {
			echo '<table class="table table-condensed table-hover">';
			echo '<thead>';
				echo '<tr>';
					echo '<th>Ticket #</th>';
					echo '<th>Account</th>';
					echo '<th>Character</th>';
					echo '<th>Purchase Date</th>';
					echo '<th>Ticket Used</th>';
					echo '<th>Spin Completed</th>';
					echo '<th>Spin Date</th>';
					echo '<th>Reward Type</th>';
					echo '<th>Reward Amount</th>';
					echo '<th>Redeem Status</th>';
					echo '<th>Redeem Date</th>';
				echo '</tr>';
			echo '</thead>';
			echo '<tbody>';
			foreach($logs as $row) {
				echo '<tr>';
					echo '<td>'.$row['id'].'</td>';
					echo '<td>'.$row['username'].'</td>';
					echo '<td>'.$row['character'].'</td>';
					echo '<td>'.$row['ticket_purchase_date'].'</td>';
					echo '<td>'.($row['ticket_used'] == 1 ? '<span class="label label-success">Yes</span>' : '<span class="label label-default">No</span>').'</td>';
					echo '<td>'.($row['spin_completed'] == 1 ? '<span class="label label-success">Yes</span>' : '<span class="label label-default">No</span>').'</td>';
					echo '<td>'.$row['spin_date'].'</td>';
					echo '<td>'.$row['reward_type'].'</td>';
					echo '<td>'.$row['reward_amount'].'</td>';
					echo '<td>'.($row['reward_redeem_status'] == 1 ? '<span class="label label-success">Redeemed</span>' : '<span class="label label-default">Not Redeemed</span>').'</td>';
					echo '<td>'.$row['reward_redeem_date'].'</td>';
				echo '</tr>';
			}
			echo '
			</tbody>
			</table>';
		} else {
			message('warning', 'There are no logs to display.');
		}
		
	echo '</div>';
echo '</div>';